<?php

// 加载公共函数库
include __DIR__.'/../../Func.php';

// 以下用于swoft加载自定义的类
$scanPaths = include __DIR__.'/PathConfig.php';
$data = [];
foreach ($scanPaths as $basePath) {
    $files = \Swoft\Helper\DirHelper::glob($basePath,'*.php');
    $baseNamespace = "Hdll\Services\\";

    foreach ( $files as $file ) {
        $pathSpace = str_replace("/var/www/swoft/vendor/hdll/services/src/","",$file);
        $pathSpace = dirname($pathSpace);
        $pathSpace = str_replace("/","\\",$pathSpace);

        $namespace = $baseNamespace.$pathSpace;

        $fileName = basename($file,'.php');

        $className = $namespace.'\\'.$fileName;
        try {
            include_once $file;
            if ( ! class_exists($className,false) ) {
                continue;
            }

            //获取注解里的table
            $res = new \ReflectionClass($className);
            $commentString = $res->getDocComment();

            if ( strpos($commentString,'@Bean()') === false ) {
                continue;
            }

            $data[$className] = ['class' => $className];

        }catch (Exception $e) {

        }

    }

}

return $data;