<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/24
 * Time: 13:57
 */
namespace Hdll\Services\Order\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferSellerCreateOrder(int $sellerId,int $storeId,int $itemId,int $selectedNum,int $orderType,float $total,float $goodsPrice,string $goodsName)
 * @method ResultInterface deferGetOrderInfoBySn(int $storeId, string $orderSn)
 * @method ResultInterface deferUpdateInfoById(int $storeId,int $orderId, array  $updateInfo)
 * @method ResultInterface deferGetSellerOrderByStoreId(int $storeId, int $itemId)
 * Interface SellerOrderInterface
 * @package Hdll\Services\Order\Lib
 */
interface SellerOrderInterface
{
    public function sellerCreateOrder(
        int $sellerId,
        int $storeId,
        int $itemId,
        int $selectedNum,
        int $orderType,
        float $total,
        float $goodsPrice,
        string $goodsName
    );


    public function getOrderInfo(int $storeId,int $orderId);

    public function getOrderInfoBySn(int $storeId, string $orderSn);

    public function updateInfoById(int $storeId,int $orderId, array  $updateInfo);

    public function getSellerOrderByStoreId(int $storeId, int $itemId);

}