<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store service
 *
 * @method ResultInterface deferGetSubStore(int $storeId, int $subStoreId)
 * @method ResultInterface deferGetSubStoreList(int $storeId, int $state = 0)
 * @method ResultInterface deferUpdateSubStore(int $storeId, int $subStoreId, array $data)
 */
interface SubStoreInterface
{
    /**
     * 获取子店铺信息
     * 
     * @param int $storeId  
     * @param int $subStoreId  
     * @return array
     */
    public function getSubStore(int $storeId, int $subStoreId);

    /**
     * 获取storeId获取所有子店铺列表
     * 
     * @param int $storeId  
     * @param int $state 子店铺状态筛选，1表示正常，2表示关闭，0表示列出所有
     * @return array
     */
    public function getSubStoreList(int $storeId, int $state = 1);

    /**
     * 修改子店铺信息
     *
     * @param integer $storeId
     * @param integer $subStoreId
     * @param array $data
     * $data字段说明：
     * subStoreName  // 门店名称
     * mobile        // 门店联系手机
     * state         // 1表示正常状态，2关闭状态
     * storeAddr     // 店铺地址
     * lntLat        // 店铺坐标
     * storeHours    // 营业时间
     * reservSpan    // 单次预约时长
     * reservMax     // 同一时间段最大预约次数
     * 
     * @return int  成功更新的条数
     */
    public function updateSubStore(int $storeId, int $subStoreId, array $data);
    
}