<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Recharge\Lib;

use Hdll\Services\Recharge\Enum\BuyCardPayStatus;
use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferPayStatus(int $storeId,int $bargainbranchId,int $status,int $orderId)
 * @method  ResultInterface deferSpendCardMoney(int $storeId, int $buyerId, array $subOrders)
 * @method  ResultInterface deferReturnCardMoney( int $storeId,int $buyerId,int $itemOrderId,string $itemTitle,int $payMoney)
 */
interface RechargeInterface
{


    /**
     * 微信支付 状态 回馈接口
     * @param string $storeId //
     * @param int $itemId // 项目ID $localorderId
     * @param int $status // BuyCardPayStatus::HAVE_PAY 成功支付  BuyCardPayStatus::PAY_EXCEPTION：未支付 （已经过期或者支付异常）
     * @return mixed
     */
    public function payStatus(
        int $storeId,
        int $itemId,
        int $status ,  //
        int $orderId);

    /**
     * 花费卡金额
     * @param int $storeId
     * @param int $buyerId
     * @param int $goodOrderId
     * @return mixed
     */
    public function spendCardMoney(int $storeId, int $buyerId, array $subOrders);

    /**
     * 退回储值卡金额
     * @param int $storeId
     * @param int $buyerId
     * @param int $itemOrderId
     * @param string $itemTitle
     * @param int $payMoney
     * @return mixed
     */
    public function ReturnCardMoney(
        int $storeId,
        int $buyerId,
        int $itemOrderId,
        string $itemTitle,
        int $payMoney
    );
}




 