<?php

namespace Hdll\Services\Common\Config;

use Swoft\Redis\Redis;
use Swoft\App;

class CfgCenter
{
	const COS            = 'cos';
	const CLS            = 'cls';
	const CMQ            = 'cmq';
	const ENCRYPT_KEY    = 'encrypt_key';
	const BACKEND_WEAPP  = 'backend_weapp';
	const FRONTEND_WEAPP = 'frontend_weapp';
	const ALIYUN_SMS     = 'aliyun_sms';
	const TENCENT_SMS    = 'tencent_sms';
	const MP             = 'mp';
	const PAY            = 'pay';
	const PAY_YUNMAI     = 'pay_yunmai';
	const PAY_YUNMAI_ISP = 'pay_yunmai_isp';
	const PAY_ZHIMEI     = 'pay_zhimei';

	/**
	 * 读取指定的配置项 - 返回数组格式
	 * (所有配置项，需预先添加到数据库中)
	 *  $cfgdata = CfgCenter::getArray(CfgCenter::COS);
	 *  var_dump($cfgdata['Weapp']['Region']); // 输出：ap-shanghai
	 *
	 * @param string $keyName 
	 * @param int    $oemId oemId==1表示是活动啦啦
	 * @return mixed
	 */
	public static function getArray($keyName, $oemId = 1)
	{
		return self::_get($keyName, $oemId);
	}

	/**
	 * 根据storeId获取所属OEM平台的配置
	 *
	 * @param string $keyName
	 * @param string $storeId
	 * @return mixed
	 */
	public static function getByStoreId($keyName, $storeId)
	{
		$dbConn = self::_dbConnect('seller');
		$result = $dbConn->get("seller", ['oemId'], ['storeId' => $storeId]);
		return self::_get($keyName, (int)$result['oemId']);
	}


	/**
	 * 根据sellerId获取所属OEM平台的配置
	 *
	 * @param string $keyName
	 * @param string $sellerId
	 * @return mixed
	 */
	public static function getBySellerId($keyName, $sellerId)
	{
		$dbConn = self::_dbConnect('seller');
		$result = $dbConn->get("seller", ['oemId'], ['sellerId' => $sellerId]);
		return self::_get($keyName, (int)$result['oemId']);
	}

	/**
	 * 根据unionId获取所属OEM平台的配置
	 *
	 * @param string $keyName
	 * @param string $unionId
	 * @return mixed
	 */
	public static function getByUnionId($keyName, $unionId)
	{
		$dbConn = self::_dbConnect('seller');
		$result = $dbConn->get("seller", ['oemId'], ['unionId' => $unionId]);
		return self::_get($keyName, (int)$result['oemId']);
	}

	/**
	 * 获取支付平台证书
	 *
	 * @param integer $storeId
	 * @param integer $isEntrusted  是否是用户托管的小程序
	 * @return void
	 */
	public static function getCertByStoreId(int $storeId, int $isEntrusted)
	{
		$dbConn = self::_dbConnect('seller');
		$result = $dbConn->get("seller", ['oemId'], ['storeId' => $storeId]);
		$oemId = (int)$result['oemId'];

	}


	private static function _get($keyName, int $oemId = 1)
	{
		$prefix = "CONFIG_CENTER:oemid_$oemId:";
		$redis = App::getBean(Redis::class);
		$data = $redis->get($prefix . $keyName);
		if($data) {
			$result = json_decode($data, true);
			return is_array($result) ? $result : $data;
		}
		// 没有缓存则从数据库读取：
		$valArr = self::_getConfigFromDb($keyName, $oemId);
		if ($valArr) { //有内容时进行redis缓存
			if (is_array($valArr)) {
				$redis->set($prefix . $keyName, json_encode($valArr), 3600);
			} else {
				$redis->set($prefix . $keyName, $valArr, 3600);
			}
		}
		return $valArr;
	}

	private static function _getConfigFromDb($keyName, $oemId)
	{
		$dbConn = self::_dbConnect('config_center');
		$result = $dbConn->select("config", ['name', 'value'], ['oemId' => $oemId, 'name' => $keyName]);
		if (!isset($result[0]['value'])) {
			return;
		}
		$valArr = json_decode($result[0]['value'], true);
		if (!is_array($valArr)) {
			return $result[0]['value'];
		}
		return $valArr;
	}

	private static function _dbConnect($database)
	{
		if (\env('ENVIRONMENT', '') == '') {
			// 返回线上数据库连接
			return new \Medoo\Medoo([
				'database_type' => 'mysql',
				'database_name' => $database,
				'server' => '172.21.0.12',
				'username' => 'configer',
				'password' => 'Cfgsu#2390f*_',
				'charset' => 'utf8'
			]);
		} else {
			// 返回测试数据库连接
			return new \Medoo\Medoo([
				'database_type' => 'mysql',
				'database_name' => $database,
				'server' => '192.168.3.202',
				'username' => 'hdller',
				'password' => 'Hdlltest888',
				'charset' => 'utf8'
			]);
		}
	}

}

