<?php

namespace Hdll\Services\Common\ClsLogger;

use Swoft\App;
use Swoole\Coroutine;
use Swoole\Coroutine\MySQL\Exception;
use Swoft\HttpClient\Client;
use Hdll\Services\Common\ClsLogger\Cls\LogGroupList;
use Hdll\Services\Common\ClsLogger\Cls\LogGroup;
use Hdll\Services\Common\ClsLogger\Cls\Log_Content;
use Hdll\Services\Common\ClsLogger\Cls\Log;

class ClsLog
{
    const TOPICID_ERROR  = '11b19b11-c6b3-45fc-ab1a-7a531558fb57';
    const TOPICID_NOTICE = 'b84f9396-d17a-4e61-88a8-11e032755732';

    public static function error($msgText, $key = ''){
        $key = empty($key) ? APP_NAME : APP_NAME.':'.$key;
        $pbData = self::createPbData($key, $msgText);
        return self::uploadToCls(self::TOPICID_ERROR, $pbData);
    }

    public static function notice($msgText, $key = '') {
        $key = empty($key) ? APP_NAME : APP_NAME.':'.$key;
        $pbData = self::createPbData($key, $msgText);
        return self::uploadToCls(self::TOPICID_NOTICE, $pbData);
    }

    private static function createPbData($key, $value)
    {
        $logGroupList = new LogGroupList;
        $logGroup = new LogGroup;
        $log = new Log;
        $logContent = new Log_Content;
        $logContent->setKey($key);
        $logContent->setValue($value);
        $log->appendContents($logContent);
        $log->setTime(time());

        $logGroup->appendLogs($log);
        $logGroup->setSource(APP_NAME);

        $logGroupList->appendLogGroupList($logGroup);

        return $logGroupList->serializeToString();
    }

    private static function uploadToCls($topicId, $pbData) {
        $authorization = ClsSignature::create();
        $uri = 'http://ap-beijing.cls.myqcloud.com/structuredlog?topic_id='.$topicId;
        for($n = 0;$n < 3;$n++){
            $res = (new Client)->post($uri, [
                'headers' => [
                    'Host' => 'ap-beijing.cls.myqcloud.com',
                    'Authorization' => $authorization,
                    'Content-Type' => 'application/x-protobuf',
                ], 
                'body'=>$pbData,
                'timeout' => 30,
            ]);
            if($res->getResponse()->getStatusCode() == 200) {
                return true;
            }
            if (App::isCoContext()) {
                Coroutine::sleep(1);
            } else {
                sleep(1);
            }
        }
        $msg = '上传腾讯云日志服务失败：'.$res->getResult();
        self::writeClsErrors($msg);
        return false;
    }

    /**
     * 腾讯日志服务上传时产生错误，这种错误需要记录在本地文件
     * 
     * @return void
     */
    private static function writeClsErrors($messageText) {
        $filename = 'cls_error.log';
        $logFile = \alias('@runtime').'/logs/'.$filename;
        if (App::isCoContext()) {
            // 协程写
            go(function () use ($logFile, $messageText) {
                $res = Coroutine::writeFile($logFile, $messageText, FILE_APPEND);
                if ($res === false) {
                    throw new \InvalidArgumentException("Unable to append to log file: {$filename}");
                }
            });
        } else {
            $fp = fopen($logFile, 'a');
            if ($fp === false) {
                throw new \InvalidArgumentException("Unable to append to log file: {$filename}");
            }
            flock($fp, LOCK_EX);
            fwrite($fp, $messageText);
            flock($fp, LOCK_UN);
            fclose($fp);
        }
    }
}
