<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Reservation\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of Reservation service
 *
 * @method ResultInterface deferGetReservById(int $id)
 * @method ResultInterface deferGetReservByDateId(int $storeId, int $dateId)
 * @method ResultInterface deferGetReservListByOrderId(int $storeId, $orderId)
 * @method ResultInterface deferModifyReservById(int $id)
 * @method ResultInterface deferCancelReservById(int $id)
 */
interface ReservationInterface
{
    /**
     * 获取某个预约的信息
     *
     * @param integer $id
     * @return array
     */
    public function getReservById(int $id);

    /**
     * 根据日期id，获取商家某一天的所有预约
     *
     * @param integer $storeId
     * @param integer $dateId
     * @return array
     */
    public function getReservByDateId(int $storeId, int $dateId);

    /**
     * 根据订单id，获取商家某个订单包含的所有预约
     *
     * @param integer $storeId
     * @param integer $orderId
     * @return void
     */
    public function getReservListByOrderId(int $storeId, int $orderId);

    /**
     * 修改某个预约信息
     *
     * @param integer $id
     * @param array $data
     * $data 字段说明：
     * ['state'] => 预约状态，默认0，如果正常结束则为1
     * ['type'] => 预约类型，备用
     * ['reservTime'] => 预约时间，时间戳格式
     * ['isConfirm'] => 1表示商家确认预约
     * ['memo'] => 预约备注
     * @return int 返回成功修改的条数
     */
    public function modifyReservById(int $id, array $data);

    /**
     * 取消某个预约
     *
     * @param integer $id
     * @return boolean 返回取消结果
     */
    public function cancelReservById(int $id);
}