<?php
//================================//
// 公共函数库
//================================//

// 执行数据库操作，并对返回结果进行处理
if(!function_exists('dbQuery')) {
	function dbQuery($result) {
        if($result instanceof \Swoft\Core\ResultInterface) {
            $result = $result->getResult();
        }
		if($result === false) {
            throw new \Exception('数据库操作错误[return:false]');
        }
        if(!is_array($result) && !is_object($result)) {
            return $result; //字符串或数字等类型直接返回
        }
        if(is_object($result) && \method_exists($result, 'toArray')) {
            $result = $result->toArray();
        }
        foreach ($result as $key => $value) {
            if(is_array($value) || is_object($value)) {
                $result[$key] = dbQuery($value);
                continue;
            }
            if($key == 'deleteTime') unset($result[$key]);
        }
        return $result;
	}
}