<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Notice\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method ResultInterface deferSend(int $storeId, array $sendTypes, array $data, int $sendTime) :bool
 */
interface NoticeInterface
{
    /**
     * 参数说明
     *
     * 微信发送消息数据结构
     * $data[NoticeEnum::TYPE_MINI_BACKEND_SEND] = [
        "uid" => 1, //用户的id
        "template_id" => "1kZ_RkkWfRrpufXNdmJYBpIhgk7ccCtPrypeJQ9WRwM",//消息模板id
        "page" => "index", //消息模板页面
        "data" => [ //消息模板数据
            "keyword1" => [
                "value" => "商品名称",
            ],
            "keyword2" => [
                "value" => "A8204427546131350100",
            ],
            "keyword3" => [
                "value" => "￥30",
            ],
            "keyword4" => [
                "value" => date('Y-m-d'),
            ]

        ]
    ];

     *
     * 短信发送消息数据结构
    $data[NoticeEnum::TYPE_TENCENT_SMS] = [
        [
            "templateId" => "178822", //模板id
            "phoneNumber" => "17558430002",
            "param" => [ //模板变量名
                "1580",
                "5"
            ]
        ]
    ];
     *
     * @param int $storeId
     * @param array $sendTypes
     * @param array $data
     * @param int $sendTime   //发送时间，立即返送填0
     * @return mixed
     */
    public function send(int $storeId, array $sendTypes, array $data, int $sendTime) :bool;
}