<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:48
 */

namespace Hdll\Services\Buyer\Lib;


use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferSaveBill(int $order_id, int $buyer_id, int $store_id, string $order_sn, int $money, string $orderName, int $orderType, int $agentId, int $itemId)
 * @method ResultInterface deferGetListByOrderId(int $storeId, int $orderId)
 * Interface AgencyInterface
 * @package App\Lib
 */
interface BillInterface
{

	/**
	 * 保存账单数据
	 * @param int    $orderId   //订单id
	 * @param int    $buyerId   // 买家id
	 * @param int    $storeId   // 店铺id
	 * @param string $orderSn   //订单号
	 * @param int    $money     //订单金额
	 * @param string $orderName //订单名称
	 * @param int    $orderType //订单类型
	 * @param int    $agentId   //代理商id
	 * @param int    $itemId
	 * @return mixed
	 * @author Administrator
	 */
	public function saveBill(
		int $orderId,
		int $buyerId,
		int $storeId,
		string $orderSn,
		int $money,
		string $orderName,
		int $orderType,
		int $agentId,
		int $itemId
	);

	public function getListByOrderId(int $storeId, int $orderId);

	public function updateByCondition(int $storeId, array $condition, array $info);

	/**
	 * 退款成功逻辑
	 *
	 * @param $storeId
	 * @param $orderId
	 * @return mixed
	 */
	public function refundSuccess($storeId, $orderId);


}