<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store-commission service
 *
 * @method ResultInterface deferGetCommSetting(int $storeId)
 * @method ResultInterface deferGetDistriRule(int $storeId)
 * @method ResultInterface deferUpdateByStoreId(int $storeId, array $data)
 * @method ResultInterface deferUpdateDistriRule(int $storeId, array $data)
 */
interface CommsettingInterface
{
    /**
     * 获取店铺代理佣金规则
     * 
     * @param int $storeId  
     * @return array
     * 返回内容说明：
     * ['state'] => 分销佣金规则是否启用，0不启用，1启用
     * ['rechargeState'] => 储值卡代理是否启用，0不启用，1启用
     * ['activityState'] => 活动代理是否启用，0不启用，1启用
     * ['rule'] => 分销佣金规则具体设置内容，json格式: {"1":35,"2":14.5}
     * ['minWithdraw'] => 最小提现金额，单位分
     * ['memo'] => 规则备注说明
     */
    public function getCommSetting(int $storeId);

    /**
     * 获取店铺分销规则
     * 
     * @param int $storeId  
     * @return array
     * 返回内容说明：
     * ['state'] => 分销规则是否启用，0不启用，1启用
     * ['rule'] => 分销规则具体设置内容，json格式: {"1":35,"2":14.5}
     * ['minWithdraw'] => 最小提现金额，单位分
     * ['memo'] => 规则备注说明
     */
    public function getDistriRule(int $storeId);

    /**
     * 根据店铺ID修改店铺代理的佣金规则
     *
     * @param integer $storeId
     * @param array $data
     * 参数$data 字段说明：
     * ['state'] => 分销佣金规则是否启用，0不启用，1启用
     * ['rule'] => 分销佣金规则具体设置内容，json格式: {"1":35,"2":14.5}
     * ['minWithdraw'] => 最小提现金额，单位分
     * ['memo'] => 规则备注说明
     * @return array
     */
    public function updateByStoreId(int $storeId, array $data);

    /**
     * 根据店铺ID修改店铺分销的规则
     *
     * @param integer $storeId
     * @param array $data
     * 参数$data 字段说明：
     * ['state'] => 分销佣金规则是否启用，0不启用，1启用
     * ['rule'] => 分销佣金规则具体设置内容，json格式: {"1":35,"2":14.5}
     * ['minWithdraw'] => 最小提现金额，单位分
     * ['memo'] => 规则备注说明
     * @return array
     */
    public function updateDistriRule(int $storeId, array $data);

    
}