<?php
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://doc.swoft.org
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */
namespace Swoft\Db;

use Hdll\Services\Common\Bean\Collector\SplitCollector;
use Swoft\Core\RequestContext;
use Swoft\Db\Bean\Collector\EntityCollector;

/**
 * Query
 */
class Query
{
    /**
     * Query查询分表处理
     * @param string $tableName
     * @param string|null $alias
     * @return QueryBuilder
     * @throws Exception\DbException
     */
    public static function table(string $tableName, string $alias = null): QueryBuilder
    {
        $query = new QueryBuilder();

        $collector = SplitCollector::getCollector();//分表搜集器

        //如果是实体且为分表实体
        if (strpos($tableName, '\\') !== false && isset($collector[$tableName])) {
            $className = $tableName;
            $tableName = $collector[$tableName]['table'];

            $entityCollector = EntityCollector::getCollector();

            //设置分表对应的className
            EntityCollector::setCollector($tableName.'_'.self::getDbNum($className), $tableName);

            //获取分表名
            $tableName = $tableName.'_'.self::getDbNum($className);
            var_dump($tableName, self::getDbNum($className),'实体');

            //设置分表类型
            $query->selectInstance($entityCollector[$className]['instance']);


        } elseif ($map = array_flip($collector['map']) && isset($map[$tableName]) ) { //非实体
            $tableName = $tableName.'_'.self::getDbNum($map[$tableName]);
            var_dump($tableName, self::getDbNum($map[$tableName]),'正常');
        }


        $query = $query->table($tableName, $alias);
        return $query;
    }

    private function getDbNum($className)
    {
        $splitCollector = SplitCollector::getCollector();
        $splitNum = $splitCollector[$className]['num'];
        $data = RequestContext::getContextData();
        $storeId = $data['userInfo']['storeId'];
        return $storeId % $splitNum;
    }
}
