<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store-template service
 *
 * @method ResultInterface deferGetTemplateList(int $onshelf = 1)
 * @method ResultInterface deferGetTemplate(int $tplId)
 * @method ResultInterface deferDelTemplate(int $tplId)
 * @method ResultInterface deferUpdateTemplate(int $tplId, array $data)
 * @method ResultInterface deferAddTemplate($data)
 */
interface TemplateInterface
{
    /**
     * 获取所有可用的个性模板列表
     * onshelf=1表示查询已上架的模板
     * onshelf=2表示查询已下架的模板
     * 
     * @Number(name="onshelf")
     * @param int $onshelf  
     * @return array
     */
    public function getTemplateList(int $onshelf = 1);

    /**
     * 根据模板ID获取单个模板信息
     *
     * @Number(name="tplId")
     * @param integer $tplId
     * @return array
     */
    public function getTemplate(int $tplId);

    /**
     * 根据模板id删除一个模板
     * 
     * @Number(name="tplId")
     * @param integer $tplId
     * @return int 返回删除成功的条数
     */
    public function delTemplate(int $tplId);

    /**
     * 根据模板id更新一个模板
     * $data 字段说明：
     * ['tplThumb'] => 模板缩略图地址
     * ['title'] => 模板标题
     * ['onshelf'] => 是否上架，1上架，2下架，下架的模板用户看不到
     * ['memo'] => 备注信息，此信息用户看不到
     * ['orderby'] => 排序值，值越大，越靠前
     *
     * @Number(name="tplId")
     * @param integer $tplId
     * @param array $data
     * @return int 返回更新成功的条数
     */
    public function updateTemplate(int $tplId, array $data);

    /**
     * 添加一个模板
     * $data 字段说明：
     * ['tplThumb'] => 模板缩略图地址
     * ['title'] => 模板标题
     * ['onshelf'] => 是否上架，1上架，2下架，下架的模板用户看不到
     * ['memo'] => 备注信息，此信息用户看不到
     * ['orderby'] => 排序值，值越大，越靠前
     *
     * @param array $data
     * @return int 返回新建模板id
     */
    public function addTemplate($data);
}