<?php

namespace hdll\services\generate;

use mysql_xdevapi\Exception;
use Swoft\Bean\Annotation\Bean;
use Swoft\Bean\Annotation\Inject;
use Swoft\Db\Db;
use Swoft\Db\Query;
use Swoft\Devtool\FileGenerator;
use Swoft\Devtool\Model\Data\SchemaData;

/**
 * @Bean()
 * Class GenData
 * @package hdll\services\generate
 */
class GenData
{


    public function getColumns($table)
    {
        $columns = Db::query("describe $table")->getResult();
        return array_column($columns, 'Field');
    }

    public function generate($params)
    {
        list($db, $table, $path, $tplFile, $tplDir) = $params;
        $this->generateData($db, $table, $path, $tplFile, $tplDir);
    }

    public function generateData($db, $table, $path, $tplFile, $tplDir)
    {
        $config = [
            'tplFilename' => $tplFile,
            'tplDir' => $tplDir,
            'className' => $table,
        ];

        $file = alias($path);
        $file .= sprintf('/%s%s.php', ucfirst($table), $tplFile);

        $columnSchemas = $this->getColumns($table);
        $data = [
            'dbName' => $db,
            'className' => ucfirst($table),
            'tableName' => $table,
            'namespace' => "App\\Models\\$tplFile",
            'columns' => $columnSchemas
        ];
        $gen = new FileGenerator($config);
        $gen->getParser()->setOpenCloseTagChars("{{", "}}");
        $gen->renderas($file, $data);

    }
}
