<?php

namespace Hdll\Services\Lottery\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferAdminCountActivity($storeId)
 * @method ResultInterface deferGetNewOrderNum($storeId, $time)
 * @method ResultInterface deferGetOnGoing($storeId, $fields = ['*'])
 * Class LotteryInterface
 * @package Hdll\Services\Lottery\Lib
 */
interface LotteryInterface
{

	/**
	 * 获取所有活动数量
	 * [
	 *      'total'=>1,
	 *      'online'=>1
	 * ]
	 * @param $storeId
	 * @return mixed
	 * @author work
	 */
	public function adminCountActivity($storeId);


	/**
	 * 获取新订单数量
	 * @param $storeId
	 * @param $time
	 * @return mixed
	 * @return number
	 * @author work
	 */
	public function getNewOrderNum($storeId, $time);

	/**
	 * 获取正在进行的活动
	 * @param       $storeId
	 * @param array $fields
	 * @return mixed
	 */
	public function getOnGoing($storeId, $fields = ['*']);
}