<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/10/9
 * Time: 10:50
 */

namespace Hdll\Services\Notice\Extensions\Notice;

use Hdll\Services\Notice\Common\WxMiniNotice;
use Hdll\Services\Notice\Enum\NoticeEnum;

class MpSender implements SenderInterface
{
	private $sendType = NoticeEnum::TYPE_MP_SEND;

	private $data;

	private $unionId;

	private $miniprogram;

	private $sendData;

	private $template;

	public function __construct(string $unionId, array $miniprogram, array $sendData, string $template)
	{
		$this->unionId = $unionId;
		$this->miniprogram = $miniprogram;
		$this->sendData = $sendData;
		$this->template = $template;
	}

	public function format()
	{
		$this->data[$this->sendType] = [
			'unionId' => $this->unionId,
			'template_id' => $this->template,
			'miniprogram' => [
				'appid' => $this->miniprogram['appId'], //小程序appid
			],
			'data' => $this->sendData
		];
		//小程序跳转（优先）
		if (isset($this->miniprogram['page'])) {
			$this->data[$this->sendType]['miniprogram']['pagepath'] = WxMiniNotice::generatePage(
				$this->miniprogram['page'],
				$this->miniprogram['param']
			);
		}
		//url跳转
		if (isset($this->miniprogram['url'])) {
			$this->data[$this->sendType]['url'] = $this->miniprogram['url'];
		}
	}

	public function getData()
	{
		return $this->data === null ? [] : $this->data;
	}

	public function getSendType()
	{
		return [$this->sendType];
	}


}