<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Recharge\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferPayStatus(int $storeId, int $itemId, int $status, int $orderId)
 * @method  ResultInterface deferSpendCardMoney(int $storeId, int $buyerId, array $subOrders, int $parentOrderId)
 * @method  ResultInterface deferReturnCardMoney(int $storeId,int $buyerId,int $itemOrderId,string $itemTitle,int $payMoney, int $parentOrderId)
 * @method  ResultInterface deferStatisNum(int $storeId)
 * @method  ResultInterface deferGetRecharge(int $storeId, int $buyerId)
 * @method  ResultInterface deferDeductMoney($storeId, $buyerId, $name, $phone, $money, $message, $escrow)
 */
interface RechargeInterface
{

    /**
     * 微信支付 状态 回馈接口
     * @param int $storeId
     * @param int $itemId   // 项目ID $localorderId
     * @param int $status   // BuyCardPayStatus::HAVE_PAY 成功支付  BuyCardPayStatus::PAY_EXCEPTION：未支付 （已经过期或者支付异常）
     * @param int $orderId   // 主订单id
     * @return mixed
     */
    public function payStatus(int $storeId, int $itemId, int $status, int $orderId);

    /**
     * 花费卡金额
     * @param int $storeId
     * @param int $buyerId
     * @param array $subOrders
     * $subOrders 示例：
     * [
     *     [
     *         'id' => 333, // 子订单id
     *         'itemName' => 'namenamename',  // 项目名
     *         'actualAmount' => 444,   // 项目价格
     *     ],
     *     [
     *         'id' => 555, 
     *         'itemName' => 'namenamename', 
     *         'actualAmount' => 666,
     *     ],
     * ]
     * @param int $parentOrderId  // 主订单id
     * @param int $extraFee 额外的费用，比如运费等
     * @return mixed
     */
    public function spendCardMoney(int $storeId, int $buyerId, array $subOrders, int $parentOrderId, int $extraFee=0);

    /**
     * 退回储值卡金额
     * @param int $storeId
     * @param int $buyerId
     * @param int $itemOrderId // 子订单
     * @param string $itemTitle // 项目名
     * @param int $payMoney // 项目价格
     * @param int $parentOrderId  // 主订单id
     * @return mixed
     */
    public function ReturnCardMoney(int $storeId, int $buyerId, int $itemOrderId, string $itemTitle, int $payMoney, int $parentOrderId);

    /**
     * 储值卡指定金额退款
     * @param $storeId
     * @param $buyerId
     * @param $amount     // 退还金额
     * @param $refundTitle    // 退款标题
     * @param $parentOrderId    // 主订单
     * @param $subOrderId // 子订单
     * @return bool
     * @throws
     */
    public function refundAmount(int $storeId, int $buyerId, int $amount, $refundTitle, $parentOrderId=0, $subOrderId=0);

    /**
     * 统计储值卡上架数/总数
     * @param int $storeId
     * @return mixed
     * 响应数据：
     * [
     *  'num' => 上架数,
     *  'total' => 总数
     * ]
     */
    public function statisNum(int $storeId);

    /**
     * 获取储值卡信息
     * @param int $storeId
     * @param int $buyerId
     * @return mixed
     */
    public function getRecharge(int $storeId, int $buyerId);

    /**
     * 线下扣款（划卡）
     * @param int $storeId
     * @param int $buyerId
     * @param $name
     * @param $phone
     * @param $money
     * @param $message
     * @param $escrow
     * @return mixed
     */
    public function deductMoney($storeId, $buyerId, $name, $phone, $money, $message, $escrow);
}




 