<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/27
 * Time: 16:28
 */

namespace Hdll\Services\Seller\Lib;

use Swoft\Core\ResultInterface;

/**
 *
 * @method ResultInterface deferGetFund($seller)
 * @method ResultInterface deferAddBalance($seller, $money, $orderSn)
 * @method ResultInterface deferReduceBalance($seller, $money, $orderSn)
 * @method ResultInterface deferAddTotal($seller, $money, $orderSn)
 * @method ResultInterface deferReduceTotal($seller, $money, $orderSn)
 * @method ResultInterface deferAddExpectFund($seller, $money, $orderSn)
 * @method ResultInterface deferReduceExpectFund($seller, $money, $orderSn)
 * @method ResultInterface deferAddFund($seller, $money, $orderSn)
 * @method ResultInterface deferAddActualCommissionFund($sellerId, $money, $orderSn)
 * Interface SellerInterface
 * @package App\Lib
 */
interface SellerFundInterface
{

	/**
	 * 增加提现金额
	 * @param $seller
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addBalance($seller, $money, $orderSn='');

	/**
	 * 减少提现金额
	 * @param $seller
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function reduceBalance($seller, $money, $orderSn='');

	/**
	 * 增加总提现金额
	 * @param $seller
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addTotal($seller, $money, $orderSn='');

	/**
	 * 减少总提现金额
	 * @param $seller
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function reduceTotal($seller, $money, $orderSn='');

	/**
	 *
	 * @param $sellerId
	 * @return mixed
	 * totalFund   累计资金
	 * balanceFund 可提现金额
	 * commissionFund  需要支付的佣金
	 * expectFund  冻结金额
	 * totalWithdraw   累计提现
	 * @author Administrator
	 */
	public function getFund($sellerId);

	/**
	 * 增加冻结金额
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addExpectFund($sellerId, $money, $orderSn='');

	/**
	 * 减少冻结金额
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function reduceExpectFund($sellerId, $money, $orderSn='');

	/**
	 * 增加金额
	 * @param $sellerId
	 * @param $balanceFund    可提现金额
	 * @param $commissionFund 佣金
	 * @return mixed
	 * @author Administrator
	 */
	public function addFund($sellerId, $balanceFund, $commissionFund, $orderSn='');


	/**
	 * 增加实付佣金
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addActualCommissionFund($sellerId, $money, $orderSn='');
}