<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/27
 * Time: 16:28
 */

namespace Hdll\Services\Seller\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferSave($referId, $unionId, $openId, $nickName, $headImgUrl, $gender = 2)
 * @method ResultInterface deferGet($id, $fields = ['*'])
 * @method ResultInterface deferGetByUnionId($unionId, $fields = ['*'])
 * @method ResultInterface deferGetByStoreId($storeId, $fields = ['*'])
 * @method ResultInterface deferUpdate($id, $data)
 * @method ResultInterface deferCountDistributionNum($sellerId)
 * @method ResultInterface deferGetByIds(array $ids, $fields = ['*'])
 * @method ResultInterface deferGetAndUpdateOpenId($unionId, $openId, $fields = ['*'])
 * @method ResultInterface deferSaveRelation($sellerId)
 * @method ResultInterface deferUpdateRelationVip($sellerId, $isVip)
 * @method ResultInterface deferCountVip($sellerId, $isVip)
 * @method ResultInterface deferCountSeller($start, $end)
 * @method ResultInterface deferGetByOpenId($openId, $fields)
 *
 * Interface SellerInterface
 * @package App\Lib
 */
interface SellerInterface
{

	/**
	 * @param        $referId
	 * @param        $unionId
	 * @param        $openId
	 * @param        $nickName
	 * @param        $headImgUrl
	 * @param int    $gender
	 * @param string $mpOpenId
	 * @param int    $oemId
	 * @return mixed
	 * @author work
	 */
	public function save($referId, $unionId, $openId, $nickName, $headImgUrl, $gender = 2, $mpOpenId = '', $oemId = 0);

	/**
	 * @param       $id
	 * @param array $fields
	 * @return mixed
	 * @author Administrator
	 */
	public function get($id, $fields = ['*']);

	/**
	 * @param       $unionId
	 * @param array $fields
	 * @return mixed
	 * @author Administrator
	 */
	public function getByUnionId($unionId, $fields = ['*']);

	/**
	 * @param $condition
	 * @param $data
	 * $data['referId']=>'来源ID'
	 * $data['unionId']=>'unionId'
	 * $data['openId']=>'openId'
	 * $data['nickName']=>'昵称'
	 * $data['headImgUrl']=>'头像URL'
	 * $data['realName']=>'真实姓名'
	 * $data['phoneNumber']=>'手机号'
	 * @return mixed
	 * @author Administrator
	 */
	public function update($condition, $data);

	/**
	 * @param       $storeId
	 * @param array $fields
	 * @return mixed
	 * @author Administrator
	 */
	public function getByStoreId($storeId, $fields = ['*']);


	public function countDistributionNum($sellerId);


	public function getByIds(array $ids, $fields = ['*']);

	public function getAndUpdateOpenId($unionId, $openId, $fields = ['*']);

	public function saveRelation($sellerId);

	public function updateRelationVip($sellerId, $isVip);

	public function countVip($sellerId);

	public function countSeller($start, $end);

	public function getByOpenId($openId, $fields);
}