<?php

namespace Hdll\Services\V2\Common\ClsLogger;

use Hdll\Services\V2\Common\Config\CfgCenter;

class ClsSignature
{
    public static function create(){
        
        $signTime = (time()-10).';'.(time()+300);
        $cosCfg = CfgCenter::getByOemId('cls', 0);
        $sha1edHttpString = sha1("post\n/structuredlog\n\n\n"); 
        $stringToSign = "sha1\n{$signTime}\n{$sha1edHttpString}\n"; 
        $signKey = hash_hmac('sha1', $signTime, $cosCfg['secretKey']); 
        $signature = hash_hmac('sha1', $stringToSign, $signKey);
        $authorization = 'q-sign-algorithm=sha1&q-ak='.$cosCfg['secretId']
                         ."&q-sign-time={$signTime}&q-key-time={$signTime}&q-header-list=&q-url-param-list=&q-signature={$signature}";
        return $authorization;
    }
}
